
CREATE TABLE `api_configurations` (
    `id` BIGINT UNSIGNED NOT NULL,
    `provider` VARCHAR(255) NULL DEFAULT NULL,
    `credentials` TEXT NULL DEFAULT NULL,
    `created_at` TIMESTAMP NULL DEFAULT NULL,
    `updated_at` TIMESTAMP NULL DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB;

ALTER TABLE `api_configurations` CHANGE `id` `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT;
INSERT INTO `api_configurations` (`provider`,`credentials`,`created_at`,`updated_at`) VALUES ('reloadly','{\"client_id\":\"----------------------\",\"client_secret\":\"----------------------\"}',NULL,NULL);

CREATE TABLE `countries` (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(255) NULL DEFAULT NULL,
    `iso_name` VARCHAR(40) NULL DEFAULT NULL,
    `continent` VARCHAR(40) NULL DEFAULT NULL,
    `currency_code` VARCHAR(40) NULL DEFAULT NULL,
    `currency_name` VARCHAR(40) NULL DEFAULT NULL,
    `currency_symbol` VARCHAR(40) NULL DEFAULT NULL,
    `flag_url` VARCHAR(255) NULL DEFAULT NULL,
    `calling_codes` TEXT NULL DEFAULT NULL,
    `status` TINYINT(1) NOT NULL DEFAULT '1',
    `created_at` TIMESTAMP NULL DEFAULT NULL,
    `updated_at` TIMESTAMP NULL DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB;

CREATE TABLE `operators` (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `country_id` INT UNSIGNED NOT NULL DEFAULT '0',
    `unique_id` INT UNSIGNED NOT NULL DEFAULT '0',
    `name` VARCHAR(255) NULL DEFAULT NULL,
    `bundle` TINYINT(1) NOT NULL DEFAULT '0',
    `data` TINYINT(1) NOT NULL DEFAULT '0',
    `pin` TINYINT(1) NOT NULL DEFAULT '0',
    `supports_local_amount` TINYINT(1) NOT NULL DEFAULT '0',
    `supports_geographical_recharge_plans` TINYINT(1) NOT NULL DEFAULT '0',
    `denomination_type` VARCHAR(40) NULL DEFAULT NULL,
    `sender_currency_code` VARCHAR(40) NULL DEFAULT NULL,
    `sender_currency_symbol` VARCHAR(40) NULL DEFAULT NULL,
    `destination_currency_code` VARCHAR(40) NULL DEFAULT NULL,
    `destination_currency_symbol` VARCHAR(40) NULL DEFAULT NULL,
    `commission` DECIMAL(28, 8) NOT NULL DEFAULT '0',
    `international_discount` DECIMAL(28, 8) NOT NULL DEFAULT '0',
    `local_discount` DECIMAL(28, 8) NOT NULL DEFAULT '0',
    `most_popular_amount` DECIMAL(28, 8) NULL DEFAULT NULL,
    `most_popular_local_amount` DECIMAL(28, 8) NULL DEFAULT NULL,
    `min_amount` VARCHAR(40) NULL DEFAULT NULL,
    `max_amount` VARCHAR(40) NULL DEFAULT NULL,
    `local_min_amount` VARCHAR(40) NULL DEFAULT NULL,
    `local_max_amount` VARCHAR(40) NULL DEFAULT NULL,
    `fx` TEXT NULL DEFAULT NULL,
    `logo_urls` TEXT NULL DEFAULT NULL,
    `fixed_amounts` TEXT NULL DEFAULT NULL,
    `fixed_amounts_descriptions` TEXT NULL DEFAULT NULL,
    `local_fixed_amounts` TEXT NULL DEFAULT NULL,
    `local_fixed_amounts_descriptions` TEXT NULL DEFAULT NULL,
    `suggested_amounts` TEXT NULL DEFAULT NULL,
    `suggested_amounts_map` TEXT NULL DEFAULT NULL,
    `fees` TEXT NULL DEFAULT NULL,
    `geographical_recharge_plans` TEXT NULL DEFAULT NULL,
    `status` VARCHAR(40) NULL DEFAULT NULL,
    `created_at` TIMESTAMP NULL DEFAULT NULL,
    `updated_at` TIMESTAMP NULL DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB;

INSERT INTO `notification_templates` (
        `id`,
        `act`,
        `name`,
        `subj`,
        `email_body`,
        `sms_body`,
        `push_notification_body`,
        `shortcodes`,
        `email_status`,
        `sms_status`,
        `push_notification_status`,
        `created_at`,
        `updated_at`
    )
VALUES
    (
        NULL,
        'TOP_UP',
        'Airtime Top Up',
        'Top Up Completed',
        'Top up {{amount}} {{site_currency}} to {{mobile_number}} has been completed successfully. Your current balance is: {{post_balance}} {{site_currency}}',
        'Top up {{amount}} {{site_currency}} to {{mobile_number}} has been completed successfully. Your current balance is: {{post_balance}} {{site_currency}}',
        NULL,
        '{\r\n\"amount\": \"amount\",\r\n\"mobile_number\": \"Recipient Mobile Number\",\r\n\"post_balance\":\"Post Balance\"\r\n}',
        '1',
        '1',
        '1',
        '2021-07-11 03:21:19',
        '2022-11-24 18:47:32'
    );
ALTER TABLE `deposits` CHANGE `btc_amo` `btc_amount` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL;
ALTER TABLE `deposits` CHANGE `final_amo` `final_amount` DECIMAL(28,8) NOT NULL DEFAULT '0.00000000';
ALTER TABLE `api_configurations` ADD `test_mode` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '1 = test mode on;\r\n2 = test mode off' AFTER `credentials`;
INSERT INTO
    `notification_templates` (
        `id`,
        `act`,
        `name`,
        `subj`,
        `email_body`,
        `sms_body`,
        `push_notification_body`,
        `shortcodes`,
        `email_status`,
        `sms_status`,
        `push_notification_status`,
        `created_at`,
        `updated_at`
    )
VALUES
    (
        NULL,
        'AIRTIME_OTP',
        'OTP for Airtime Top-Up',
        'OTP for Top-Up',
        '<div>Your OTP is {{otp}}</div>',
        'Your OTP is {{otp}}',
        NULL,
        '{\r\n \"otp\": \"One Time Password\"\r\n}',
        '1',
        '1',
        '1',
        '2021-07-11 03:21:19',
        '2022-08-14 10:00:35'
    );

ALTER TABLE `operators` ADD `reloadly_status` VARCHAR(40) NULL DEFAULT NULL AFTER `status`;
ALTER TABLE `operators` CHANGE `status` `status` TINYINT(1) NOT NULL DEFAULT '1';
ALTER TABLE `api_configurations` ADD `access_token` LONGTEXT NULL DEFAULT NULL AFTER `test_mode`, ADD `token_expired_on` TIMESTAMP NULL DEFAULT NULL AFTER `access_token`;
ALTER TABLE `api_configurations` ADD `token_type` VARCHAR(40) NULL DEFAULT NULL AFTER `test_mode`; 