@php
    $banner = getContent('banner.content', true);
@endphp
<section class="banner-section section-overlay bg-img" data-background-image="{{ asset($activeTemplateTrue . 'images/thumbs/hero-bg.jpg') }}">
    <div class="container">
        <div class="row">
            <div class="col-lg-7 col-md-6">
                <div class="banner-content">
                    <h1 class="banner-content__title">{{ __(@$banner->data_values->heading) }}</h1>
                    <div class="banner-content__bottom flex-align gap-4">
                        <span class="banner-animation">
                            <i class="icon-Asset-1"></i>
                        </span>
                        @guest
                            <a href="{{ @$banner->data_values->button_link }}" class="btn btn--base">{{ __(@$banner->data_values->button_text) }}</a>
                        @endguest
                        <a href="{{ @$banner->data_values->video_link }}" id="previewVideo" class="video-preview">
                            <div class="video-preview__img">
                                <img src="{{ getImage('assets/images/frontend/banner/' . @$banner->data_values->video_thumbnail, '105x65') }}" alt="@lang('image')" />
                            </div>
                            <div class="video-preview__icon">
                                <i class="fas fa-play"></i>
                            </div>
                        </a>
                        <h5 class="video-preview__text">@lang('Watch Video')</h5>
                    </div>
                </div>
            </div>

            <div class="col-lg-5 col-md-6">
                <div class="banner-thumb">
                    <div class="banner-img">
                        <img src="{{ getImage('assets/images/frontend/banner/' . @$banner->data_values->image, '495x560') }}" alt="@lang('image')" />
                        <div class="happy-user d-flex justify-content-between">
                            <img class="happy-user__img" src="{{ getImage('assets/images/frontend/banner/' . @$banner->data_values->user_images, '210x70') }}" alt="@lang('image')" />
                            <div class="happy-user__content">
                                <h4 class="happy-user__title">{{ __(@$banner->data_values->total_user) }}</h4>
                                <p class="happy-user__desc fs-15">{{ __(@$banner->data_values->title) }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="secure-mark d-flex align-items-center">
                        <span class="secure-mark__img flex-center">
                            <i class="fa fa-check"></i>
                        </span>
                        <div class="secure-mark__content">
                            <h6 class="secure-mark__title">{{ __(@$banner->data_values->security_title) }}</h6>
                            <p class="secure-mark__desc">{{ __(@$banner->data_values->security_subtitle) }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@push('style-lib')
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/magnific-popup.css') }}" />
@endpush

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/magnific-popup.min.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $("#previewVideo").magnificPopup({
                type: "iframe",
            });
        })(jQuery)
    </script>
@endpush
